package gov.va.med.mhv.usermgmt.main.service.adapter.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.GenericComposite;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v23.message.ACK;
import ca.uhn.hl7v2.model.v23.segment.RDF;
import ca.uhn.hl7v2.model.v23.segment.RDT;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.PipeParser;
import gov.va.med.mhv.common.data.model.Facility;
import gov.va.med.mhv.common.data.model.Patient;

@Component
class LookupPatientDecoderWithMiddleName {
	
    private static final Log LOG = LogFactory.getLog(LookupPatientDecoderWithMiddleName.
            class);
	
	private static final String RDF = "RDF";

	private static final String RDT = "RDT";

	private  String firstName;

	private  String lastName;
	
	private  String middleName;
	
	private  String gender;

	private  String birthDate;

	private  String ssn;
	
	public LookupPatientDecoderWithMiddleName(){
		
	}

	public LookupPatientDecoderWithMiddleName(String firstName, String lastName, String middleName, String gender,
		Date birthDate, String ssn)
	{
		this.firstName = StringUtils.upperCase(firstName);
		this.lastName = StringUtils.upperCase(lastName);
		this.middleName = StringUtils.upperCase(middleName);
		this.gender = StringUtils.upperCase(gender);		
		this.ssn = ssn;
		SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
		this.birthDate = df.format(birthDate);
	}

	public Patient decode(String msg) throws EncodingNotSupportedException,
		HL7Exception, DuplicatePatientException
	{
		PipeParser parser = new PipeParser();

		ACK ack_q02 = (ACK) parser.parse(msg);
		RDF rdf = (RDF) ack_q02.get(RDF);
		int columns = Integer.parseInt(rdf.getNumberOfColumnsPerRow()
			.getValue());

		Structure[] patients = null;
		try {
			patients = ack_q02.getAll(RDT);
		} catch (HL7Exception e) {
			// No patients
		}

		return extractPatient(patients, columns);
	}
	
	private Patient extractPatient(Structure[] patients, int columns) 
		throws HL7Exception, DuplicatePatientException 
	{
		if (patients == null) {
			return null;
		}
		List<Patient> exactMatchPatients = new ArrayList<Patient>();
		for (int i = 0; i < patients.length; i++) {
			if (isExactMatch(columns, (RDT) patients[i])) {
				exactMatchPatients.add(decodePatient(columns, 
					(RDT) patients[i]));
			} // else: Not an exact match
		}
		if (exactMatchPatients.size() > 1) {
			StringBuffer message = new StringBuffer(
				"Multiple ICN values found: ");
			int i = 0;
			for (Patient p : exactMatchPatients) {
				if (i > 0) {
					message.append(", ");
				}
				i++;
				message.append(p.getIcn());
			}
			throw new DuplicatePatientException(message.toString());
		}

		return (exactMatchPatients.size() == 1) ? exactMatchPatients.get(0) 
			: null;
	}
	
	private boolean isExactMatch(int columns, RDT encodedPatient)
		throws HL7Exception
	{	
		assert (encodedPatient !=null);
	    
		boolean match = (columns >= 7) // Must have enough columns to determine match
			&& equals(encodedPatient.getField(1), lastName)
			&& equals(encodedPatient.getField(2), firstName)
			&& equals(encodedPatient.getField(3), ssn)
			&& equals(encodedPatient.getField(4), 8, birthDate)
			&& equals(encodedPatient.getField(5), 1, middleName)	    //Only compare first character (CR834)
			&& equals(encodedPatient.getField(6), gender);

		if(!match){
		     equals(encodedPatient.getField(1), lastName,
		               buildMessage(fieldToString(encodedPatient.getField(7)), "__LAST NAME__", fieldToString(encodedPatient.getField(1)), lastName));
		     equals(encodedPatient.getField(2), firstName,
		               buildMessage(fieldToString(encodedPatient.getField(7)), "__FIRST NAME__", fieldToString(encodedPatient.getField(2)), firstName));
		     equals(encodedPatient.getField(3), ssn,
		               buildMessage(fieldToString(encodedPatient.getField(7)), "__SSN__", fieldToString(encodedPatient.getField(3)), ssn));
		     equals(encodedPatient.getField(4), 8, birthDate, 
		    	       buildMessage(fieldToString(encodedPatient.getField(7)), "__BIRTHDATE__", fieldToString(encodedPatient.getField(4)), birthDate));
		     equals(encodedPatient.getField(5), 1, middleName, 
		    	       buildMessage(fieldToString(encodedPatient.getField(7)), "__MIDDLE NAME (first character)__", fieldToString(encodedPatient.getField(5)), middleName));
		     equals(encodedPatient.getField(6), gender,
		               buildMessage(fieldToString(encodedPatient.getField(7)), "__GENDER__", fieldToString(encodedPatient.getField(6)), gender));
		}

		return match;
	 }


	private String buildMessage(String ICN, String entityName, String mpiValue, String mhvValue) {
	  StringBuilder message = new StringBuilder();
	  message.append("ICN: '")
		.append(ICN)
		.append("' ")
		.append(entityName)
		.append("Value from MPI: '")
		.append(mpiValue)
		.append("' Value from MHV: '")
		.append(mhvValue)
		.append("'");
	  
	  return message.toString();
	}	
	
	
	private Patient decodePatient(int columns, RDT encodedPatient) 
		throws HL7Exception
	{
		assert (encodedPatient != null);
		Patient patient = new Patient();
		
		if (columns >= 7) {
			patient.setIcn(fieldToString(encodedPatient.getField(7)));
		}
		
		if (columns >= 9) {
			List<String> stationNumbers = fieldToStrings(encodedPatient.getField(9));
			for (String stationNumber: stationNumbers) {
				if (!StringUtils.isBlank(stationNumber)) {
					Facility facility = new Facility();
					facility.setName(stationNumber);
					//TODO:srini - Add method in patient Domain and uncomment below line
					//patient.addFacility(facility);
				}
			}
		} 
		
		return patient;
	}
	
	private boolean equals(Type[] field, String value, String message) {
    	String value2 = fieldToString(field);
   		return equals(value, value2);
	}
	
	private boolean equals(Type[] field, String value) {
		String value2 = fieldToString(field);
		boolean result = equals(value, value2);
		return result;
	}

	private boolean equals(Type[] field, int size, String value) {
		return equals(StringUtils.substring(value,0,size), StringUtils.substring(fieldToString(field),0,size));
	}

	private boolean equals(Type[] field, int size, String value, String message) {
		boolean result = equals(StringUtils.substring(value,0,size), StringUtils.substring(fieldToString(field),0,size));
		if(!result){
    			if(LOG.isDebugEnabled()){        	
    				LOG.debug("MHV-MPI field MISMATCH: " + message);
    			}
        	}
		return result;
	}

	private boolean equals(String value1, String value2) {
		value1 = StringUtils.upperCase(value1);
		value2 = StringUtils.upperCase(value2);
		return StringUtils.equals(value1, value2)
			|| (StringUtils.isBlank(value1) && StringUtils.isBlank(value2));
	}

	private String fieldToString(Type[] field) {
		if (field == null) { 
			return null;
		}
		if (field.length == 0) {
			return null;
		}
		Type data = ((Varies) field[0]).getData();
		if (data == null) {
			return null;
		}
		return data.toString();
	}

	private List<String> fieldToStrings(Type[] field){
		List<String> strings = new ArrayList<String>();
		if (field == null) {
			return strings;
		}
		for (int k = 0; k < field.length; k++) {
			Type data = ((Varies) field[k]).getData();
			if (data instanceof GenericComposite) {
				GenericComposite gc = (GenericComposite) data;
				Type[] rpt = gc.getComponents();
				data = ((Varies) rpt[0]).getData();
			}
			if (data != null) {
				strings.add(data.toString());
			}
		}
		return strings;
	}


}
